//
// objekt koule s normalami ve vrcholech
//
//
//            )\a                            _|_|_|_|_|
//              )      ]?'                         _|     _|_|_|       _|_|_|
//                 _aaaa//      aaa/             _|       _|    _|   _|    _|
// )??))??''     a//     )')ba     ???\        _|         _|    _|   _|    _|
//           aa???           ?_a             _|_|_|_|_|   _|_|_|       _|_|_|
//         _jP                  ]\                        _|               _|
//         )Q     'Q      Q'    Qf                        _|           _|_|
//          4b/                 4
//           )]//             _JP
//              )'aaaaaaaaaa_Q)'               _|_|   _|            _|   _|_|   _|_|_|_|
//          ??a        ?          aaa        _|    _| _|            _| _|    _| _|
//             ?'ba           _/a??          _|    _| _|  _|      _|   _|    _| _|_|_|
//              _j?'         )?4aa           _|    _| _|_|_|_|    _|   _|    _|       _|
//            aj)      aa_/     _aQ'         _|    _|     _|    _|     _|    _| _|    _|
//             ??PET//)?  ??b.?)?              _|_|       _|    _|       _|_|     _|_|

using System;
using Microsoft.DirectX.Direct3D;
using Microsoft.DirectX;

namespace zpg
{
	/// <summary>
	/// Objekt pro vykreslovani koule. Objekt si vytvori VertexBuffer a indexbuffer naplni jej vrcholy.
	/// Metoda Render vykresli buffery do zarizeni device (parametr konstruktoru)
	/// </summary>
	public class Sphere : GraphicObject
	{
		private VertexBuffer vb;
		private IndexBuffer ib;
		private int pointCount = 0;
		private int triangleCount = 0;

		/// <summary>
		/// konstruktor koule, vytvo vertexbuffer a indexbuffer
		/// </summary>
		/// <param name="device">zazen pro kter se budou vytvet buffery</param>
		/// <param name="phiRes">rozlien ve smru phi (poet polednkovch dlk)</param>
		/// <param name="thetaRes">rozlien ve smru theta (poet rovnobkovch dlk)</param>
		/// <param name="radius">polomr koule</param>
		public Sphere(Device device, int phiRes, int thetaRes, double radius)
            :base( device)
		{
			
			pointCount = phiRes*(thetaRes+1);
			triangleCount = 2*phiRes*thetaRes;

			double phiStep = 2*Math.PI/phiRes;			/// hel pro jednotliv kroky ve smru phi a theta
			double thetaStep = Math.PI/thetaRes;	

			double phi = 0;
			double theta = -Math.PI/2;

			/// Vytvoen VertexBufferu. Smr theta je o jedna vt, protoe v tomto smru nen s uzaven
			vb = new VertexBuffer(
				typeof(CustomVertex.PositionNormal),
				phiRes*(thetaRes+1),
				device,
				Usage.WriteOnly,
				CustomVertex.PositionNormal.Format,
				Pool.Managed);

			CustomVertex.PositionNormal[] vertices = (CustomVertex.PositionNormal[])vb.Lock(0,0);
			for (int x = 0;x<phiRes;x++)
			{
				theta = -Math.PI/2;
				for (int y = 0;y<(thetaRes+1);y++)
				{
					int index = x*(thetaRes+1)+y;
					/// polohu vertexu urme jako bod v polrnch souadnicch
					vertices[index].Position = new Vector3( (float) (radius*Math.Cos(phi)*Math.Cos(theta)),
															(float) (radius*Math.Sin(theta)),
															(float) (radius*Math.Sin(phi)*Math.Cos(theta)));
					/// normla je shodn se smrovm vektorem vertexu, normalizaci provd DirectX
					vertices[index].Normal = vertices[index].Position;
					theta += thetaStep;
				}
				phi += phiStep;
			}
			vb.Unlock();

			/// Vytvoen indexbufferu
			ib = new IndexBuffer(typeof(short),phiRes*thetaRes*6,device,Usage.WriteOnly,Pool.Managed);
			short[] indices = (short[])ib.Lock(0,0);
			for (int x = 0;x<(phiRes-1);x++)
				for (int y = 0;y<thetaRes;y++)
				{
					int index = (x*(thetaRes)+y)*6;
					int vbindex = x*(thetaRes+1)+y;
					indices[index    ] = (short) (vbindex);
					indices[index + 1] = (short) (vbindex+ (thetaRes+1));
					indices[index + 2] = (short) (vbindex+ (thetaRes+1) +1);
					indices[index + 3] = (short) (vbindex);
					indices[index + 4] = (short) (vbindex+ (thetaRes+1) +1);
					indices[index + 5] = (short) (vbindex+1);
				}
			
			/// vytvoen poslednch polednkovch dlk je nutno oetit zvl᚝, protoe indexy
			/// pesahuj na zatek indexbufferu. Dalo by se to tak eit vpoetem celoselnho
			/// zbytku, ale nebylo by to efektivn.
			for (int y = 0;y<thetaRes;y++)
			{
				int index = ((phiRes-1)*(thetaRes)+y)*6;
				int vbindex = (phiRes-1)*(thetaRes+1)+y;
				indices[index    ] = (short) (vbindex);
				indices[index + 1] = (short) (y);
				indices[index + 2] = (short) (y + 1);
				indices[index + 3] = (short) (vbindex);
				indices[index + 4] = (short) (y +1);
				indices[index + 5] = (short) (vbindex + 1);
			}
			ib.Unlock();
		}

        protected override void Render(GraphicObjectView view)
        {
            graphicsDevice.VertexFormat = CustomVertex.PositionNormal.Format;
            graphicsDevice.SetStreamSource(0, vb, 0);
            graphicsDevice.Indices = ib;
            graphicsDevice.DrawIndexedPrimitives(PrimitiveType.TriangleList, 0, 0, pointCount, 0, triangleCount);
        }
	}
}
