//
//            )\a                            _|_|_|_|_|
//              )      ]?'                         _|     _|_|_|       _|_|_|
//                 _aaaa//      aaa/             _|       _|    _|   _|    _|
// )??))??''     a//     )')ba     ???\        _|         _|    _|   _|    _|
//           aa???           ?_a             _|_|_|_|_|   _|_|_|       _|_|_|
//         _jP                  ]\                        _|               _|
//         )Q     'Q      Q'    Qf                        _|           _|_|
//          4b/                 4
//           )]//             _JP
//              )'aaaaaaaaaa_Q)'               _|_|   _|            _|   _|_|   _|_|_|_|
//          ??a        ?          aaa        _|    _| _|            _| _|    _| _|
//             ?'ba           _/a??          _|    _| _|  _|      _|   _|    _| _|_|_|
//              _j?'         )?4aa           _|    _| _|_|_|_|    _|   _|    _|       _|
//            aj)      aa_/     _aQ'         _|    _|     _|    _|     _|    _| _|    _|
//             ??PET//)?  ??b.?)?              _|_|       _|    _|       _|_|     _|_|
//
using System;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;


using System.IO;

namespace zpg
{
	/// <summary>
	/// Formular, ktery vytvori D3D device a ve smycce se prekresluje
	/// </summary>
	public class RenderForm : System.Windows.Forms.Form
	{
		private Device device = null;
        

        private Camera camera;
        private Point centr;
        private int verticalControlInvert = 1;
        private HeadsUpDisplay textEngine;
        private TextBox fpsBox;
        private TextBox positionBox;
        internal WorldView world;
        private Console console;

		/// <summary>
		/// Konstruktor nastavi velikost a vlastnosti okna
		/// </summary>
		public RenderForm()
		{
			this.ClientSize = new System.Drawing.Size(800, 600);				/// velikost okna
			this.FormBorderStyle = FormBorderStyle.FixedSingle;					/// styl ramecku okna
			this.MaximizeBox = false;											/// minim. a maxim. tlacitko schovane
			this.MinimizeBox = false;
		}

		/// <summary>
		/// Metoda se pokusi inicializovat D3D. In case of error throws DirectXException
		/// </summary>
		private void D3DInit()
		{
            PresentParameters param = new PresentParameters();
            param.Windowed = true;											/// chceme pustit v okne
            param.SwapEffect = SwapEffect.Discard;							/// pri preklapeni bufferu nebudou ovlivneny ostatni buffery
            param.EnableAutoDepthStencil = true;
            param.SwapEffect = SwapEffect.Copy;
            param.AutoDepthStencilFormat = DepthFormat.D16;

		    device = new Device(0,											/// vytvoreni zarizeni na defaultnim adapteru
					    DeviceType.Hardware,								/// pouziva se HW rasterizace
					    this,												/// okno do ktereho se bude kreslit
					    CreateFlags.SoftwareVertexProcessing,				/// softwarove zpracovani vrcholu
					    param);												/// dalsi parametry
                                                                            /// 
            world =(WorldView) new World(device).CreateView();
            
            camera = new Avatar( world, ClientSize.Width / ClientSize.Height);
            //camera = new Camera(new Vector3(-1, 0, 0), new Vector3(1, 0, 0), ClientSize.Width / ClientSize.Height);


            Rectangle scrren = new Rectangle(0,0,ClientSize.Width, ClientSize.Height);
            textEngine = new HeadsUpDisplay(device, scrren);
            fpsBox = textEngine.createTextBox( new Rectangle(0,0,500,200), Color.Yellow, 1);
            positionBox = textEngine.createTextBox(
                new Rectangle(ClientSize.Width-200, ClientSize.Height-50, 200, 50)
                , Color.Yellow
                , 1);

            console = textEngine.createConsole(
                new Rectangle(10, ClientSize.Height - 110, ClientSize.Width -250, 100)
                , Color.White
                , Color.FromArgb(255,  Color.LightGreen)
                , 5
                , new ConsoleCommandHandler( world ));

            console.Visible = false;
    	}
        
		/// <summary>
		/// Vycisti okno a vykresli scenu
		/// </summary>
		private void Render() 
		{

            device.Clear(ClearFlags.Target | ClearFlags.ZBuffer, System.Drawing.Color.Black, 1, 0);		/// vycisti pamet hloubky a barev
            device.BeginScene();												/// zacatek sceny
            
            device.RenderState.CullMode = Cull.None;							/// orezavani odvracenych sten je vypnuto
            device.RenderState.Lighting = false;								/// osvetleni je vypnuto
            
            device.RenderState.NormalizeNormals = true;

            device.Transform.Projection = camera.Projection;
            device.Transform.View = camera.lookAt(device.Transform.View);						/// nastaveni matice pohledu - pozice kamery
            device.Transform.World = Matrix.Identity;							/// nastaveni matice objektu
                                                                                /// 
            world.DoUpdate();                                                                                
            world.DoRendering();
            
            fpsBox.AddText("FPS:" + Framerate.getFramerate());
            positionBox.AddText("["
                + camera.Position.X.ToString("f2")
                + "," + camera.Position.Y.ToString("f2")
                + "," + camera.Position.Z.ToString("f2") + "]");


            textEngine.Render();
            device.EndScene();													/// konec sceny
            device.Present();


            //device.Transform.Projection = Matrix.P
            centr = new Point(this.ClientSize.Width / 2, this.ClientSize.Height / 2);
            centr = PointToScreen(centr);
             
		}

		/// <summary>
		/// Metoda pro reakci na udalosti pohybu mysi
		/// </summary>
		protected override void OnMouseMove(System.Windows.Forms.MouseEventArgs e)
		{
            float xrelRad = ((((float)e.X) / (this.ClientSize.Width / 2)) - 1) * (float)Math.PI / 2;
            float yrelRad = ((((float)e.Y) / (this.ClientSize.Height / 2)) - 1) * (float)Math.PI / 2;

            if (xrelRad == 0 && yrelRad == 0)
                return;

            camera.Rotate(xrelRad, verticalControlInvert * yrelRad);
            Cursor.Position = centr;
            
		}

        
        
        protected override bool ProcessDialogKey(Keys keyData)
        {

            if (console.Visible)
            {
                switch (keyData)
                {
                    case Keys.Oemtilde:
                        console.Visible = false;
                    break;
                    default:
                        console.ProcessKey(keyData);
                    break;
                }

            }
            else
            {
                switch (keyData)
                {
                    case Keys.W:
                        camera.GoFront();
                        break;
                    case Keys.S:
                        camera.GoBack();
                        break;
                    case Keys.A:
                        camera.GoLeft();
                        break;
                    case Keys.D:
                        camera.GoRight();
                        break;
                    case Keys.U:
                        verticalControlInvert *= -1;
                        break;
                    case Keys.Oemtilde:
                        console.Visible = true;
                        break;
                }
            }
            return true;
        }
		/// <summary>
		/// Po spusteni se pokusi inicializovat Direct3D. V pripade uspechu
		/// Prekresluje okno a zpracovava zpravy, dokud existuje okno.
		/// </summary>
		static void Main()
		{
            Directory.SetCurrentDirectory(Application.StartupPath + @"\..\..\");
			RenderForm frm = new RenderForm();									/// vytvoreni formulare
            frm.D3DInit();													/// pokud se podari inicializovat d3d
			
			frm.Show();														/// zobrazeni formulare 
		
			while(frm.Created)												/// a dokud formular existuje
			{
				frm.Render();												/// vykreslovat scenu
				Application.DoEvents();										/// a zpracovavat zpravy
                Framerate.CalculateFrameRate();
			}
			
		}


        class ConsoleCommandHandler : CommandHandler
        {
            private WorldView world;

            public ConsoleCommandHandler(WorldView world)
            {
                this.world = world;
            }

            /**
             * Handle command passed from console.
             * Return text to be displayed to user
             */
            public String ProcessCommand(String command)
            {
                if ("Noon".ToUpper().Equals(command.ToUpper()))
                {
                    world.SunView.Noon();
                    return "And it has become noon.";
                }

                if ("Morning".ToUpper().Equals(command.ToUpper()))
                {
                    world.SunView.Morning();
                    return "And it has become moorning.";
                }

                if ("Evening".ToUpper().Equals(command.ToUpper()))
                {
                    world.SunView.Evening();
                    return "And it has become evenning.";
                }


                return "Unknown Command";
            }

            /**
             * Return maximum length of command
             */
            public int getMaxCommandLength()
            {
                return 15;
            }
        }

	}

}
