using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace zpg
{
    class WorldView:GraphicObjectView
    {
        public WorldView(World world)
            : base(world)
        {
            TerrainView = (TerrainView) world.Terrain.CreateView();
            TerrainView.Scale(
                Properties.Settings.Default.terrainHeight
                , Properties.Settings.Default.terrainElevation
                , Properties.Settings.Default.terrainWidth);
            Vector3 shift = TerrainView
                .ToWorldCoordinates(new Vector3(-0.5f, 0, -0.5f));
            TerrainView.Translate(shift);

            Material terrainMaterial = new Material();
            terrainMaterial.Diffuse = System.Drawing.Color.Brown;
            terrainMaterial.Ambient = System.Drawing.Color.DarkGray;
            TerrainView.Material = terrainMaterial;


            Vector3 center = TerrainView
                .ToWorldCoordinates(new Vector3(.5f, 1f, .5f));
            Vector3 sunPosition = TerrainView
                .ToWorldCoordinates(new Vector3(.5f, 2f, .5f));

            SunView = new SunSphereView(world.Sphere
                , TerrainView.ToWorldCoordinates(new Vector3(1, 0, 0))
                //, center
                , sunPosition);

            Material sunMaterial = new Material();
            sunMaterial.Diffuse = System.Drawing.Color.Yellow;
            sunMaterial.Ambient = System.Drawing.Color.Yellow;
            SunView.Material = sunMaterial;
            SunView.Scale(10, 10, 10);
            SunView.Noon();
        }

        public override void Update()
        {
            SunView.DoUpdate();
            TerrainView.DoUpdate();
        }




        /**
         * Get the terrain view
         */
        public TerrainView TerrainView
        {
            get { return terrainView; }
            set { terrainView = value; }
        }

        /**
         * Get the sun view
         */
        public SunSphereView SunView
        {
            get { return sunView; }
            set { sunView = value; }
        }

        /**
         * Terrain
         */
        private TerrainView terrainView;

        /**
         * Sun
         */
        private SunSphereView sunView;


    }
}
