using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace zpg
{
    class World:GraphicObject
    {
        /**
         * A world 
         */
        public World(Device graphicsDevice)
            : base( graphicsDevice )
        {
            terrain = new Terrain(graphicsDevice);
            sphere = new Sphere(graphicsDevice, 20, 20, 1);
        }
        
        protected override void Render(GraphicObjectView view)
        {
            WorldView worldView = (WorldView)view;
            
            graphicsDevice.Lights[0].Type = LightType.Directional;
            graphicsDevice.Lights[0].Diffuse = System.Drawing.Color.Gold;
      
            graphicsDevice.Lights[0].Direction = worldView.SunView.Direction;
            graphicsDevice.Lights[0].Diffuse = System.Drawing.Color.LightYellow;
            graphicsDevice.Lights[0].Enabled = true;
            graphicsDevice.RenderState.Lighting = true;
            graphicsDevice.RenderState.Ambient = System.Drawing.Color.DarkGray;
            
            worldView.TerrainView.DoRendering();
            worldView.SunView.DoRendering();
        }

        public override GraphicObjectView CreateView()
        {
            return new WorldView( this );
        }

        /**
         * Get the sphere
         */
        public Sphere Sphere
        {
            get { return sphere; }
        }


        /**
         * Get the terrain
         */
        public Terrain Terrain
        {
            get { return terrain; }
        }

        /**
         * Terrain
         */
        private Terrain terrain;

        /**
         * Sphere
         */
        private Sphere sphere;
    }
}
