using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace zpg
{
    class TerrainView:GraphicObjectView
    {
        public TerrainView(Terrain terrain)
            : base(terrain)
        {

        }

        public override void Update() { }

        /**
         * Return true if given object is in projection of terrain into XZ plane.
         * Arguments are WORLD COORDINATES
         */
        public bool IsInTerrain(float Qx, float Qz)
        {
            Vector3 terrain = ToObjectCoordinates(new Vector3(Qx, 0, Qz));
            return ((Terrain)DataSource).IsInTerrain( terrain.X, terrain.Z );
        }

        /**
         * Compute elevation.
         * takes and returns values in WORLD COORDINATES
         * 
         */
        public float GetElevation(float Qx, float Qz)
        {
            Vector3 terrain = ToObjectCoordinates(new Vector3(Qx, 0, Qz));
            terrain.Y = ((Terrain)DataSource).GetElevation(terrain.X, terrain.Z);
            return ToWorldCoordinates(terrain).Y;
        }

        public Terrain Terrain
        {
            get { return (Terrain)DataSource; }
        }
    }
}
