using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX.Direct3D;
using Microsoft.DirectX;

namespace zpg
{
    public class SunSphereView: GraphicObjectView
    {

        /**
         * Create a lighting ball orbiting in eastWest - up 
         */
        public SunSphereView(GraphicObject data, Vector3 eastWest, Vector3 noonPosition)
           :base( data )
        {
            initialPosition = noonPosition;
            axis = Vector3.Cross(initialPosition, eastWest);
        }

        public override void Update()
        {
            double elementAngle = 2 * Math.PI / dayPeriod;
            DateTime now = DateTime.Now;
            TimeSpan duration = now - lastTimeTick;

            double angle = duration.TotalMilliseconds * elementAngle;
            if (angle > min_angle)
            {
                RotateAxis(axis, (float)angle);
                position = Vector3.TransformNormal(initialPosition, Transformation);
                lastTimeTick = now;
            }
        }

        /**
         * Make it noon
         */
        public void Noon()
        {
            Transformation = Matrix.Identity;
            position = initialPosition;
            Translate(position);
            lastTimeTick = DateTime.Now;
        }

        /**
         * Make it evening
         */
        public void Evening()
        {
            Noon();
            RotateAxis(axis, (float) (3 * Math.PI / 8 ));
        }
        /**
         * Make it morning
         */
        public void Morning()
        {
            Noon();
            RotateAxis(axis, (float)(-3 * Math.PI / 8));
        }


        public long DayPeriod
        {
            get { return dayPeriod; }
            set { dayPeriod = value; }
        }

        public Vector3 Position
        {
            get { return position; }
        }

        /**
         * Actual Direction of the sun light
         */
        public Vector3 Direction
        {
            get { return Vector3.Normalize( Vector3.Multiply(position, -1) ); }
        }

        /**
         * Where the sun is at the moment
         */
        private Vector3 position;

        /**
         * East - West direction on X-Z row
         */
//        private Vector3 eastWestDirection;

        /**
         * Sun rotates arod this axis
         */
        private Vector3 axis;
        /**
         * Last time I checked time
         */
        private DateTime lastTimeTick;

        /**
         * How long the day is(millis)
         */
        //private long dayPeriod = 2 * 60 * 60 * 1000;
        private long dayPeriod = 30000;

        private double min_angle = Math.PI / 180;

        private Vector3 initialPosition;
    }
}
