using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace zpg
{
    public abstract class GraphicObject
    {
        protected static int graphicStreamRegistry=0;

        protected static int getFreeStreamIndex()
        {
            return graphicStreamRegistry++;
        }

        /**
         * Create a new instance
         */
        public GraphicObject(Device graphicsDevice)
        {
            this.graphicsDevice = graphicsDevice;
        }

        /**
         * Render this object
         */
        public void DoRendering(GraphicObjectView view)
        {
            graphicsDevice.Transform.World = view.Transformation;
            graphicsDevice.RenderState.FillMode = view.FillMode;
            graphicsDevice.Material = view.Material;
            Render(view);
        }

        public virtual GraphicObjectView CreateView()
        {
            return new DummyView( this );
        }

        /**
         * Render this object specifics
         */
        protected abstract void Render(GraphicObjectView view);

        /**
         * Graphics device to use
         */
        protected Device graphicsDevice;

        public class DummyView : GraphicObjectView
        {

            public DummyView(GraphicObject data)
                : base(data)
            { }

            public override void Update()
            {
            }
        }
    }

    
}
