using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;
using System.Drawing;



namespace zpg
{
    class Camera
    {
        public Camera(Vector3 position, Vector3 direction, float aspectRatio)
        {
            Position = position;
            Direction = direction;
            Projection =  Matrix.PerspectiveFovLH(
                (float)Math.PI / 4
                ,aspectRatio
                ,1
                ,500
            );
        }

        /**
         * Move the camera forward
         */
        public virtual void GoFront()
        {   
            float q = (float)1 * speed_movement / (float)Framerate.getFramerate();
            Vector3 _direction = Vector3.Multiply(direction,q);
            position = Vector3.Add(position, _direction);
        }
        /**
         * Move the camera backward
         */
        public virtual void GoBack()
        {
            float q = (float)1 * speed_movement / Framerate.getFramerate();
            Vector3 _direction = Vector3.Multiply(direction, q);
            position = Vector3.Subtract(position, _direction);
        }
        /**
         * Move the camera left
         */
        public virtual void GoLeft()
        {
            float q = (float)1 * speed_movement / Framerate.getFramerate();
            Vector3 plane = Vector3.Cross( UP, direction);
            plane.Multiply( q );
            position = Vector3.Subtract(position, plane);
        }
        /**
         * Move the camera right
         */
        public virtual void GoRight()
        {
            float q = (float)1 * speed_movement / Framerate.getFramerate();
            Vector3 plane = Vector3.Cross(UP, direction);
            plane.Multiply( q );
            position = Vector3.Add(position, plane);
        }

        public Matrix lookAt(Matrix view)
        {
            return Matrix.LookAtLH(position, Vector3.Add(position, direction), UP);
        }

        /**
         * Rotace camera directed by angles(RAD) relative to current position
         */
        public void Rotate(float xrel, float yrel)
        {
            Matrix transform = Matrix.RotationAxis(UP, xrel);

            zenith += yrel;
            if (Math.Abs(zenith) >= max_vertical_angle)
            {
                zenith -= yrel;
            }
            else
            {
                Vector3 plane = Vector3.Cross(UP, direction);
                transform.Multiply(Matrix.RotationAxis(plane, yrel));
            }
            direction.TransformNormal(transform);
        }

        public Vector3 Direction
        {
            get { return direction; }
            set { direction = value; direction.Normalize(); }
        }

        public Vector3 Position
        {
            get { return position; }
            set { position = value; }
        }


        public Matrix Projection
        {
            get { return projection; }
            set { projection = value; }
        }
        /**
         * POsition of the camera
         */
        protected Vector3 position;
        /**
         * Where is camera headed
         */
        protected Vector3 direction;

        /**
         * Speed of turning around
         */
        protected float speed_rotation = 1;
        /**
         * Speed of movement
         */
        protected float speed_movement = 10f;
        /**
         * UP direction
         */
        protected Vector3 UP = new Vector3(0f, 1f, 0f);
        /**
         * zenith limit
         */
        private float max_vertical_angle = (float)Math.PI / 2;
    
        /**
         * Vertical angle
         */
        private float zenith = 0;

        /**
         * Projection matrix
         */
        private Matrix projection;
    }
}
