using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace zpg
{
    class Axis : GraphicObject
    {
        VertexBuffer axis = null;

        public Axis(Device graphicsDevice)
            : base(graphicsDevice)
        {
            axis = new VertexBuffer(typeof(CustomVertex.PositionColored),	/// buffer obsahuje pouze souradnice
            6,												/// celkem 10 bodu 			
            graphicsDevice,											/// zarizeni pro ktere je buffer vytovren
            Microsoft.DirectX.Direct3D.Usage.WriteOnly,		/// do bufferu se bude pouze zapisovat
            CustomVertex.PositionColored.Format,				
            Pool.Managed );									/// jakym zpusobem je VB zpravovan

            CustomVertex.PositionColored[] _axis = (CustomVertex.PositionColored[])axis.Lock(0, 0);
            _axis[0] = new CustomVertex.PositionColored(0, 0, -1, 0xFF0000);//red
            _axis[1] = new CustomVertex.PositionColored(0, 0, 1, 0xFF0000);
            _axis[2] = new CustomVertex.PositionColored(0, -1, 0, 0xFFFF00);//yellow
            _axis[3] = new CustomVertex.PositionColored(0, 1, 0, 0xFFFF00);
            _axis[4] = new CustomVertex.PositionColored(-1, 0, 0, 0x0000FF);//blue
            _axis[5] = new CustomVertex.PositionColored(1, 0, 0, 0x0000FF);
            axis.Unlock();
        }

        protected override void Render(GraphicObjectView view)
        {
 //FIXME:           graphicsDevice.SetStreamSource(0, vertexBuffer, 0);
            graphicsDevice.RenderState.FillMode = view.FillMode;
            graphicsDevice.Material = view.Material;
            graphicsDevice.VertexFormat = CustomVertex.PositionColored.Format;		/// format dat
            graphicsDevice.DrawPrimitives(PrimitiveType.LineList, 0, 3);
        }
    }
}
