using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace zpg
{
    class Avatar:Camera
    {

        /**
         * Create an avatar 
         */
        public Avatar(WorldView world, float aspectRatio)
            : base(new Vector3(0, 0, 0), new Vector3(1, 0, 0)
            , aspectRatio)
        {
            float widthMeter = 1f / world.TerrainView.Terrain.Resolution.Width;
            float heightMeter = 1f / world.TerrainView.Terrain.Resolution.Height;
            Vector3 _meter = world.TerrainView.ToWorldCoordinates( new Vector3(widthMeter, 0, heightMeter));
            Vector3 zero = world.TerrainView.ToWorldCoordinates(new Vector3(0, 0, 0));
            zero.Y = 0;
            _meter.Subtract(zero);
            float meter = _meter.Length() / (float)( Math.Sqrt(2));
            speed_movement = speed * meter;
            this.world = world;
            position.Y = world.TerrainView.GetElevation(position.X, position.Z) + eyeElevation;
        }


        /**
         * Move the camera forward
         */
        public override void GoFront()
        {
            Vector3 _direction = Vector3.Multiply(direction, 1);//clone
            _direction.Y = 0;
            _direction.Normalize();
            _direction.Multiply( moveQuocient() );
            position = Vector3.Add(position, _direction);
            position.Y = world.TerrainView.GetElevation(position.X, position.Z) + eyeElevation;
            if (! world.TerrainView.IsInTerrain(position.X, position.Z))
            {
                position.Subtract(_direction);
            }

        }
        /**
         * Move the camera backward
         */
        public override void GoBack()
        {
            Vector3 _direction = Vector3.Multiply(direction, 1);//clone
            _direction.Y = 0;
            _direction.Normalize();
            _direction.Multiply( moveQuocient() );
            position = Vector3.Subtract(position, _direction);
            position.Y = world.TerrainView.GetElevation(position.X, position.Z) + eyeElevation;
            if (!world.TerrainView.IsInTerrain(position.X, position.Z))
            {
                position.Add(_direction);
            }

        }
        /**
         * Move the camera left
         */
        public override void GoLeft()
        {
            Vector3 plane = Vector3.Cross(UP, direction);
            plane.Multiply( moveQuocient() );
            position = Vector3.Subtract(position, plane);
            position.Y = world.TerrainView.GetElevation(position.X, position.Z) + eyeElevation;
            if (!world.TerrainView.IsInTerrain(position.X, position.Z))
            {
                position.Add(plane);
            }
        }
        /**
         * Move the camera right
         */
        public override void GoRight()
        {
            Vector3 plane = Vector3.Cross(UP, direction);
            plane.Multiply( moveQuocient() );
            position = Vector3.Add(position, plane);
            position.Y = world.TerrainView.GetElevation(position.X, position.Z) + eyeElevation;
            if (!world.TerrainView.IsInTerrain(position.X, position.Z))
            {
                position.Subtract(plane);
            }

        }

        private float moveQuocient()
        {
            return speed_movement / Framerate.getFramerate();
        }

        /**
         * Elevation of eye above terrain
         */ 
        private float eyeElevation = 1.85f;// meter
        /**
         * Walk speed of avatar m/s
         */
        private float speed = 3;
        /**
         * Terrain to walk on
         */
        private WorldView world;
    }
}
