#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <string.h>
     
#include "errors.h"
          
#define MAXMSG  512
#define MAXUSERS 20
#define WELCOME "Welcome in simple TCP chat user: "
#define NEWUSER "New user: " 
#define TOOMANYUSERS "Too many users connected, sorry\n"

   
int chatline_lenght;
char chatline[MAXMSG];        
char cislo[20]; 
     
int make_socket (uint16_t port)
{
        int server_sock;
        struct sockaddr_in name;
        int yes = 1;
     
        /* Vytvoreni socketu */
        server_sock = socket (PF_INET, SOCK_STREAM, 0);
        if (server_sock < 0)
        {
                err(2);
        }
     
        /* tento radek zpusobi, ze pri opakovanem restartu serveru, bude volani
        funkce bind() uspesne, kdo neveri, at ho zakomentuje :)) */
        if(setsockopt(server_sock, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(yes)) == -1) 
        {
		err(3);
        }

        /* pojmenovani socketu */
        name.sin_family = AF_INET;
        name.sin_port = htons (port);
        name.sin_addr.s_addr = htonl (INADDR_ANY);
        if (bind (server_sock, (struct sockaddr *) &name, sizeof (name)) < 0)
        {
		err(4);
        }
     
        return server_sock;
}

int read_from_client (int filedes)
{
        char buffer[MAXMSG];
        int nbytes;
     
        nbytes = recv(filedes, buffer, MAXMSG -1,0);
        if (nbytes < 0)
        {
		err(5);
		return -1;
        }
        else if (nbytes == 0)
                return -1;
        else
        {
                /* cteni dat a ulozeni do pomocne promenne pro poslani dalsim socketum */
                fprintf (stderr, "Server got message %d byte! \n",nbytes);
		sprintf(cislo,"%d",filedes);
		strcpy(chatline,cislo);
		strcat(chatline,": ");
		strcat(chatline,buffer);

		/* dopocteni delky radku */
		chatline_lenght=nbytes + 2 + strlen(cislo);
				
                return 0;	
        }
}

int chatd (int port)
{
        int server_sock;
        fd_set active_fd_set, read_fd_set;
        int fd;
	int fd_c;
        struct sockaddr_in clientname;
        size_t size;
                     
        /* Vytvoreni socketu */
        server_sock = make_socket (port);
        if (listen (server_sock, 1) < 0)
        {
		err(2);
        }
     
        /* inicializace setu socketu */
        FD_ZERO (&active_fd_set);
        FD_SET (server_sock, &active_fd_set);
     
        while (1)
        {
                /* cekej dokud neco neprijde na nektery z aktivnich socketu */
                read_fd_set = active_fd_set;
                if (select (FD_SETSIZE, &read_fd_set, NULL, NULL, NULL) < 0)
                {
			err(5);
                }
     
                /* Obsluz vsechny sockety na kterych neco prislo. */
                for (fd = 0; fd < FD_SETSIZE; ++fd)
                        if (FD_ISSET (fd, &read_fd_set))
                        {
                                if (fd == server_sock)
                                {
                                        /* request na spojeni na serverovem socketu */
                                        int new;
                                        size = sizeof (clientname);
                                        new = accept (server_sock,
                                                      (struct sockaddr *) &clientname,
                                                      &size);
                                        if (new < 0)
                                        {
                                        	err(6);
                                        }	
					/* osetreni maximalniho poctu pripojenych klientu */                                      
         				if (new >= 4+MAXUSERS) 
         				{
	                                        fprintf (stderr,
	                                                 "Server: connect from %s, port %hd unsuccessful, too many users !\n",
	                                                 inet_ntoa (clientname.sin_addr),
	                                                 ntohs (clientname.sin_port));
					  
                                                if (send(new,TOOMANYUSERS,sizeof(TOOMANYUSERS), 0) == -1)
                                                {                                                
                                                        err(7);                                  
                                                }                                                
         					close(new);
					}
					else
					{	
	                                        fprintf (stderr,
	                                                 "Server: connect from %s, port %hd.\n",
	                                                 inet_ntoa (clientname.sin_addr),
	                                                 ntohs (clientname.sin_port));
					  
						/* pridat noveho klienta do setu */
	                                        FD_SET (new, &active_fd_set);

						/* privitani noveho klienta */					
						strcpy (chatline,WELCOME);
						sprintf(cislo,"%d",new);
						strcat(chatline,cislo);
						strcat(chatline,"\n");
					
						if (send(new,chatline,strlen(chatline), 0) == -1)                                                                             
						{                                                                                                                   
							err(7);
						}                                    
	                                        for (fd_c = 0; fd_c < FD_SETSIZE; ++fd_c)
	                                        {
	                                                if (((FD_ISSET (fd_c, &active_fd_set)))&& (fd_c != new) && (fd_c != server_sock))
	                                                {
								strcpy(chatline,NEWUSER);
								sprintf(cislo,"%d",new);
								strcat(chatline,cislo);
								strcat(chatline," connected\n");                                        
								if (send(fd_c,chatline,strlen(chatline),0) == -1) 
								{
									err(7);
								} 
	                                                }
	                                        }     		        

	                                }
	                        }        
                                else
                                {
                                        /* data prisli na jiz obsluhovany socket */
                                        if (read_from_client (fd) < 0)					{	
                                                /* klient se odpojil */
                                                FD_CLR (fd, &active_fd_set); /* odeblani klienta ze setu */
                                                close (fd);
                                                /* oznameni odpojeni klienta ostatnim */
	                                        for (fd_c = 0; fd_c < FD_SETSIZE; ++fd_c)
	                                        {
	                                                if (((FD_ISSET (fd_c, &active_fd_set)))&& (fd_c != server_sock))
	                                                {
								strcpy(chatline,NEWUSER);
								sprintf(cislo,"%d",fd);
								strcat(chatline,cislo);
								strcat(chatline," disconnected\n");                                        
								if (send(fd_c,chatline,strlen(chatline),0) == -1) 
								{
									err(7);
								} 
	       	                                        }
	                                        }     		        
                                        }
                                        else 
                                        {
                                                for (fd_c = 0; fd_c < FD_SETSIZE; ++fd_c)
                                                {
                                                	if (((FD_ISSET (fd_c, &active_fd_set)))&& (fd_c != fd) && (fd_c != server_sock))
                                                	{
								if (send(fd_c,chatline,chatline_lenght, 0) == -1)
								{                                                                                                                   
									err(7);
								}                                    
                                                     	}
                                                }     		        
                                        }
                                }
		}
        }
}


