/*                                                                                                                                    
Simple TCP chat system                                                                                                          
Copyright (C) 2007, Martin Lipinsky, martin@lipinsky.cz                                                                                   
                                                                                                                                      
This program is free software; you can redistribute it and/or modify
as you wish.                                                                   
*/                       

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

#include "chatd.h"
#include "errors.h" 


/* konstanty */
#define PORT 2222
#define D_DEC 10

/* main cast programu */
int main(int argc, char *argv[]) {

	/* pomocna promenna pro parsovani cisla portu */
        char *pom;
        int port;

        /* kontrola zda je pusteny soubor max s jednim parametrem */ 
        if (argc > 2)
        {
                /* pokud ne, vypis jak se program pouziva a ukonci se */
                usage(argv[0]);
                return(1);
        }

	/* defaultne je port PORT */
	port=PORT;
	/* byl-li zadan jako parametr, zkus ho oparsovat a zmenit */
        if (argv[1])
        {
		port = (int) strtol(argv[1], &pom, D_DEC);
		fprintf(stderr,"Binduji na port: %d\n",port);
		/* v pripade ze argument nebyl cele cislo */
                if (!port) err(1);
        }

	/* hlavni vykonna cast programu */
	chatd(port);

        /* vrat ze je vsechno v poradku */
        return EXIT_SUCCESS;
}
