package cz.magus.sort;

public class SortTest {

	public static final int RANDOM_SIZE = 100;
	public static final int RANDOM_LENGHT = 20;
	
	/**
	 * Metoda generujici pole intu o velikosti size.
	 * @param size
	 * @return
	 */
	public static final int[] generateRandomArray(int size) {
		int[] result = new int[size];
		for (int i = 0; i < result.length; i++) {
			result[i] = (int)((Math.random() * RANDOM_SIZE)+1);
		}
		return result;
	}
	
	/** 
	 * Metoda ktera prevede pole intu na string oddeleny carkami.
	 * Je to udelane kvuli vypisu na obrazovku.
	 * @param array
	 * @return
	 */
	public static final String arrayToString(int[] array) {
		String result = "[ ";
		for (int i = 0; i < array.length; i++) {
			result += Integer.toString(array[i]);
			if (i < array.length - 1) {
				result += ", ";
			}
		}
		return result + " ]";
	}

	/**
	 * Zavola druh trideni na zadane pole intu.
	 * @param sort
	 * @param array
	 */
	public static final void testSort(Sort sort,int[] array) {
		sort.setData(array);
		sort.sort(true);
		System.out.println("Od nejmensiho: " + arrayToString(array) + "\n swapCount = " + sort.getSwapCount() + ", compareCount = " + sort.getCompareCount());
		sort.sort(true);
		System.out.println("Jeste jednou : " + arrayToString(array) + "\n swapCount = " + sort.getSwapCount() + ", compareCount = " + sort.getCompareCount());
		sort.sort(false);
		System.out.println("Od nejvetsiho: " + arrayToString(array) + "\n swapCount = " + sort.getSwapCount() + ", compareCount = " + sort.getCompareCount());
	}

	/**
	 * Hlavni metoda volajici postupne vsechny implementovane druhy trideni.
	 * na stejne nahodne vygenerovane pole.
	 * Je mozno ji podstrcit i jedno predpripravene polosetridene pole.
	 * @param args
	 */
	public static void main(String[] args) {
		// Vygeneruje nahodne pole intu 
		int[] randomArray = generateRandomArray(RANDOM_LENGHT);
        
		// Pripravi nova pole aby se mohla tridit stejna data
		int[] randomPole1 = new int[RANDOM_LENGHT];
		int[] randomPole2 = new int[RANDOM_LENGHT];
		int[] randomPole3 = new int[RANDOM_LENGHT];
		int[] randomPole4 = new int[RANDOM_LENGHT];

		// Udelej kopie vygenerovaneho pole aby se mohla tridit stejna data
		System.arraycopy(randomArray,0, randomPole1,0,RANDOM_LENGHT);
		System.arraycopy(randomArray,0, randomPole2,0,RANDOM_LENGHT);
		System.arraycopy(randomArray,0, randomPole3,0,RANDOM_LENGHT);
		System.arraycopy(randomArray,0, randomPole4,0,RANDOM_LENGHT);

		
		// Setrid pomoci ruzneho trideni
		System.out.println("Tridena data : " + arrayToString(randomArray));

		System.out.println("\nOtestuj narocnost BUBBLE sortu");
		testSort(new BubbleSort(),randomPole2);	
		System.out.println("\nOtestuj narocnost INSERT sortu");
		testSort(new InsertSort(),randomPole3);	
		System.out.println("\nOtestuj narocnost SELECT sortu");
		testSort(new SelectSort(),randomPole4);	
	}

}
