package cz.magus.sort;

public abstract class SortAdapter implements Sort {
 
	protected int[] data;
	protected int swapCount = 0;
	protected int compareCount = 0;
	
	public SortAdapter() {
	}
	
	public SortAdapter(int[] data) {
		super();
		setData(data);
	}

	public final void setData(int[] usersdata) {
		data = usersdata;		
	}
	
	/**
	 * prohodi mezi sebou prvky data[index1] a data[index2]
	 * @param data
	 * @param index1
	 * @param index2
	 */
	protected void swap(int index1, int index2) {
		final int backup = data[index1];
		data[index1] = data[index2];
		data[index2] = backup;
		swapCount++;
	}

	/**
	 * porovna prvky number1 a number2 podle poradi "order"
	 * @param number1
	 * @param number2
	 * @param order true = vzestupne, false = sestupne
	 * @return true, pokud je prvek data[index1] > data[index2] v pripade, ze order je true
	 *         true, pokud je prvek data[index1] < data[index2] v pripade, ze order je false
	 */
	protected boolean compareInts(int number1, int number2, boolean order) {
		compareCount++;
		return (order) ? (number1 > number2) : (number1 < number2);
	}
	
	/**
	 * porovna prvky data[index1] a data[index2] podle poradi "order"
	 * @param index1
	 * @param index2
	 * @param order true = vzestupne, false = sestupne
	 * @return true, pokud je prvek data[index1] > data[index2] v pripade, ze order je true
	 *         true, pokud je prvek data[index1] < data[index2] v pripade, ze order je false
	 */
	protected boolean compare(int index1, int index2, boolean order) {
		return compareInts(data[index1], data[index2], order);
	}

	/**
	 * Snuluje pocet vymen a zavola prislusnou implementaci trideni.
	 */
	public void sort(boolean order) {
		swapCount = 0;
		compareCount = 0;
		sortImpl(order);
	}

	/** 
	 * Implementuje vlastni trideni vzestupne nebo sestupne
	 * @param order
	 */
	public abstract void sortImpl(boolean order);
	
	/**
	 * Vraci pocet prohozeni prvku
	 */
	public int getSwapCount() {
		return swapCount;
	}
	
	/**
	 * Vraci pocet poronavani dvou prvku
	 */
	public int getCompareCount() {
		return compareCount;
	}
	
}
